/* $Id: datarate.c,v 1.4 1998/07/20 23:37:02 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/***************************************************************************

test datarate using VME reads

***************************************************************************/

/* set _HPUX_SOURCE for time functions */
#ifndef WIN32
#define  _HPUX_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>                     /* in error.c */
#include <ctype.h>                      /* in machine.c */
#include <math.h>                       /* in filter.c, trigger.c */
#include <signal.h>                     /* in io.c, machine.c */
#include <setjmp.h>                     /* in sema.h, io.c */
#include <time.h>                       /* in many files */

#ifdef WIN32
#include <windows.h>
#endif

#define INSTR_REAL32

#include "hpe1432.h"


#define BLOCK_SIZE 100000l
#define LOOPS 20


static void gettime(double *secs)
{
#ifdef WIN32
	long msec;

	msec=GetTickCount();
	*secs=(double)msec*0.001;
#else
    struct timeval tv;
    struct timezone tz;

    if (gettimeofday(&tv, &tz) != 0)
    {
        *secs = 0;
        return;
    }

    *secs = tv.tv_sec + 0.000001 * tv.tv_usec;

#endif
}

void main()
{
ViSession	session;
ViInt32		channels[10];
ViInt32		gid,avflag;
ViReal64	*data;
char		st[100];
ViInt32		actualCount;
ViInt32		i;
ViStatus	vierr;
double		time1,time2,total;
ViInt32		readtypeindex,datasize,datasizeindex;
char *		readtypestring;
char *		datasizestring;
FILE        *fd;
int			bytesperpoint;
int			MXIbytesperpoint;


    /* clear the log file */
    fd=fopen("drlog","w");
	if(fd)
	{
		fclose(fd);
	}
	else
	{
		printf("unable to open logfile: ""drlog""\n");
	}

    printf("mallocing %ld bytes ...",BLOCK_SIZE*sizeof(ViReal64));
    fflush(stdout);
    data=malloc(BLOCK_SIZE*sizeof(ViReal64)); /* malloc for largest */
	if(!data)
	{
		printf("malloc failed\n");
			return;
	}
	printf(" Done\nInitializing E143X\n");

    /* initialize instrument  This code ASSUMES hpe1432 at address 8 */
    vierr=hpe1432_init("VXI0::8::INSTR",0,1,&session);
    if(vierr)
    {
        printf("Is there an E1432 at address 8?\n");
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);	    
        exit(0);
    }

    /* make an array of input channel numbers (only one in this simple demo) */
    channels[0]=1;

    vierr=hpe1432_createChannelGroup(session,1,channels,&gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* set the fifo blocksize */
    vierr=hpe1432_setBlocksize(session,gid,BLOCK_SIZE);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    for(readtypeindex=0;readtypeindex<3;readtypeindex++)
    for(datasizeindex=0;datasizeindex<3;datasizeindex++)
    {

        /* set data size */
        switch(datasizeindex)
        {
            case 0: /* size 16 */
		datasize=HPE1432_DATA_SIZE_16;
		datasizestring="HPE1432_DATA_SIZE_16";
		    MXIbytesperpoint=2;
                break;
            case 1: /* size 32 */
		datasize=HPE1432_DATA_SIZE_32;
		datasizestring="HPE1432_DATA_SIZE_32";
	    MXIbytesperpoint=4;
                break;
            case 2: /* float 32 */
		datasize=HPE1432_DATA_SIZE_FLOAT32;
		datasizestring="HPE1432_DATA_SIZE_FLOAT32";
	    MXIbytesperpoint=4;
                break;
        }

        vierr=hpe1432_setDataSize(session,gid,datasize);
        if(vierr)
        {
            hpe1432_error_message(session,vierr,st);
            printf("error %d = %s\n",vierr,st);
            exit(0);
        }


        /* get some data coming */
        vierr=hpe1432_initMeasure(session,gid);
        if(vierr)
        {
            hpe1432_error_message(session,vierr,st);
            printf("error %d = %s\n",vierr,st);
            exit(0);
        }
	    printf("waiting for data\n");
	    total=0;

        for(i=LOOPS+1;i>0;i--)
        {
	    do {
                vierr=hpe1432_blockAvailable(session, gid, &avflag);
                if(vierr)
                {
                    hpe1432_error_message(session,vierr,st);
                    printf("error %d = %s\n",vierr,st);
                    exit(0);
                }
            } while (!avflag);
            
            	
            switch(readtypeindex)
	    {
	    case 0: /* float64 */
	        gettime(&time1);
                vierr=hpe1432_readFloat64Data(session,gid,
                                              HPE1432_TIME_DATA,
                                              data,
                                              BLOCK_SIZE,
                                              &actualCount,
                                              HPE1432_NO_WAIT_FLAG);
	        gettime(&time2);
		readtypestring="readFloat64Data";
		    bytesperpoint=8;
		break;
	    case 1: /* float32 */
	        gettime(&time1);
                vierr=hpe1432_readFloat32Data(session,gid,
                                              HPE1432_TIME_DATA,
                                              (ViReal32 *)data,
                                              BLOCK_SIZE,
                                              &actualCount,
                                              HPE1432_NO_WAIT_FLAG);
	        gettime(&time2);
		readtypestring="readFloat32Data";
		    bytesperpoint=4;
		break;
	    case 2: /* raw */
	        gettime(&time1);
                vierr=hpe1432_readRawData(session,gid,
                                              HPE1432_TIME_DATA,
                                              (char *)data,
                                              BLOCK_SIZE,
                                              &actualCount,
                                              HPE1432_NO_WAIT_FLAG);
	        gettime(&time2);
		readtypestring="readRawData";
		    bytesperpoint=MXIbytesperpoint;
		break;
	    }
            if(vierr)
            {
                hpe1432_error_message(session,vierr,st);
                printf("error %d = %s\n",vierr,st);
                exit(0);
            }
	    /* skip first block */
	    if(i<=LOOPS)
	        total += time2-time1;
	    printf("%d points read in %lf seconds, loop %d, %s\n",
			BLOCK_SIZE,time2-time1,i,(i<=LOOPS)?"":"Skipped");

        } /* end of data collection loop */


  printf("%s: %s\n",readtypestring,datasizestring);
  printf("%d loops x %d blocksize = %d points in %lf seconds \n",
	     LOOPS, BLOCK_SIZE, LOOPS*BLOCK_SIZE, total );

  printf("%lf pts/sec * %d MXIbytes/point = %le MXIbytes/sec\n",
	      (double)LOOPS*BLOCK_SIZE/total,MXIbytesperpoint,
		  (double)LOOPS*BLOCK_SIZE/total*MXIbytesperpoint);
   
  printf("%lf pts/sec * %d bytes/point = %le pseudobytes/sec\n",
	      (double)LOOPS*BLOCK_SIZE/total,bytesperpoint,
		  (double)LOOPS*BLOCK_SIZE/total*bytesperpoint);
    
  {
	  
		  fd=fopen("drlog","a");
	  if(fd)
	  {
          fprintf(fd,"%s: %s\n",readtypestring,datasizestring);
          fprintf(fd,"%d loops x %d blocksize = %d points in %lf seconds \n",
	              LOOPS, BLOCK_SIZE, LOOPS*BLOCK_SIZE, total );

          fprintf(fd,"%lf pts/sec * %d MXIbytes/point = %le MXIbytes/sec\n",
	      (double)LOOPS*BLOCK_SIZE/total,MXIbytesperpoint,
		  (double)LOOPS*BLOCK_SIZE/total*MXIbytesperpoint);


          fprintf(fd,"%lf pts/sec * %d bytes/point = %le pseudobytes/sec\n",
	              (double)LOOPS*BLOCK_SIZE/total,bytesperpoint,
		         (double)LOOPS*BLOCK_SIZE/total*bytesperpoint);
		  fprintf(fd,"-------------------------------------------------------------------\n");
		  fclose(fd);
	  }
  }
	  



    } /* end of dual for loops, datatype and datasize */



}





